<?php
namespace Rtb_objects;
use Helper\utils;
use Helper\validate;

/**
 * Request class
 *
 * This class handles all the paramenters and send it to SSP component to get a response,
 * It inherits 2 other class params values are defined and validated
 *
 */
class Request_handler {

    var $error_log = array();

    public function __construct() {
        //constructor method
    }

    /*
     * 
     * name: request
     * @param
     * @return
     * 
     */

    public function request($request_details,$djax_zoneinfo) 
	{
        $aConf = $GLOBALS['_MAX']['CONF'];
        $required_params = $this->is_required_params_provided();
        $utils = new Utils;
        if (empty($required_params)) {
            $is_valid = $this->validate_params();
            //check for required params
            $all_params_error = array_map(array($utils, 'walk_error_array'), $is_valid);
            $consolidated_errors = $utils->array_remove_empty($all_params_error);
            if (!empty($consolidated_errors)) {
                $error_message = $utils->formated_error_message($consolidated_errors);
                $this->error_log = $error_message;
                return (json_encode($error_message));
            } else {
                $data = $utils->isolate_data_array($is_valid);
                //ALL params verified, send to create request method
                $json_response = self::create_request($data, $request_details,$djax_zoneinfo['agency_id']);
                if ($json_response)
                #return the response back.
                    return ($json_response);
                else
                    return false;
            }
        }
        else {
			
          $this->error_log = $required_params; 
            return (json_encode($required_params));
        }
    }
    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function create_request($request_data, $request_details,$agency_id) { 
	
        $aConf = $GLOBALS['_MAX']['CONF'];
        $time_stamp = date('Y:m:d H:i:s');
        $impression_id = md5(uniqid($time_stamp, true));
        $request = array();
        //Replace with original params
        $utils = new Utils;
        $defined_constants = $utils->defined_constants();
        //Error handling method written in Utils class
        $old_error_handler = set_error_handler(array($utils, 'myErrorHandler'));
        //$request_id=$_SESSION['request_id'];
        //Merge with the request data
        $impression_id_array['impression_id'] = $impression_id;
        $this->set_value('impression_id', $impression_id);
        $request_data = array_merge($impression_id_array, $request_data);
        $request_data = array_merge($request_id_array, $request_data);
		//~ print_r($request_data); die("tesrt");
        $traffic = new Traffic();
        //DEFUALT :: For the exchange that is folowing open RTB standards )
        if ($request_details) {
            $log_msg = "[Initandlisten]  *****Listening objects ";
            debug_rtb($log_msg, PEAR_LOG_INFO);
            $log_msg.="[Initandlisten]   *****Initilizing...";
            debug_rtb($log_msg, PEAR_LOG_INFO);
			$exchangedetails=array();
            foreach ($request_details as $campaign_id => $row) 
			{
					$exchange_id=$row['exchange_id'];
					$exchangedetails[$campaign_id]=$row;
                    $class_name =  "Open_rtb";
                    $log_msg="   [Initandlisten]  *****Requesting for CAMPAIGNID-".$campaign_id;
                    debug_rtb($log_msg, PEAR_LOG_INFO);
                    $auction_type = array("auction_type" => $row['auction_type']);
                    $request_data = array_merge($request_data, $auction_type); 
					$request_data['buyer_uid'] = md5($exchange_id);
					$exchangeid[] = $exchange_id;
					$multi_campaign_id[] = $campaign_id;	
					$save_objects = $traffic->save_rtb_objects($request_data, $time_stamp,$exchange_id, $campaign_id);
					print_r($save_objects); die("save");
					$dj_dsp_id=$save_objects['requestid'];
					$save_objects=$save_objects['djaxresponse'];
					$data = $this->prepare_request_hirearchy($dj_dsp_id, $impression_id, $save_objects);
					$multirequestid[$campaign_id]=$dj_dsp_id;
                        if ($save_objects) {
                            $log_msg = "    [Requestgenerator]  Request formed with provided objects sucessfully";
                            $multi_data[$campaign_id] = $data;
                            debug_rtb($log_msg, PEAR_LOG_INFO);    
                        } else {
                            $this->error_code = '501';
                            $this->error_log = "Network error.Try again after some time.";
                        }
            }
		   }
		   print_r($multi_data); print_r($multi_campaign_id); print_r($multirequestid);exit;
        $obj = new $class_name(); 
        $json_response=$obj->execute($multi_data,$exchangedetails,$impression_id,$multi_campaign_id,$multirequestid,$agency_id);
        if ($json_response)
        {
         return ($json_response);
		}
        else
        {
            return false;
		}
    }
    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function validate_params() {
        //Load the predefined constants
        $utils = new Utils;
        $validate = new Validate;
        $defined_constants = $utils->defined_constants();

        if (is_array($defined_constants) AND !empty($defined_constants)) {
            foreach ($defined_constants as $key => $value) {
                if (array_key_exists($key, $defined_constants) AND !empty($this->$key)) {
                    switch ($value['type']) {
                        case '_integer':
                            $prep[] = $validate->validate_is_integer($key, $this->$key);
                            break;
                        case '_float':
                            $prep[] = $validate->validate_is_float($key, $this->$key);
                            break;
                        case '_string':
                            $prep[] = $validate->validate_is_string($key, $this->$key);
                            break;
                        case '_array_of_string':
                            $prep[] = $validate->validate_is_array_string($key, $this->$key);
                            break;
                        case '_array_of_integer':
                            $prep[] = $validate->validate_is_array_integer($key, $this->$key);
                            break;
                    }
                }
            }
            return $prep;
        }
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function is_required_params_provided() {
        $utils = new Utils;
        $required_params = $utils->create_required_params_array();
        if (is_array($required_params) AND $required_params) {
            foreach ($required_params as $key => $value) {
                if (empty($this->$key))
                    $error[$key] = $key . " Is required";
            }
            if (!empty($error))
                return $error;
        } else
            return false;
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function set_value($feild_name, $feild_value) {
        $utils = new Utils;
        $defined_constants = $utils->defined_constants();

        if (!empty($feild_name) AND !empty($feild_value)) {
            if (array_key_exists($feild_name, $defined_constants)) {
                $log_msg = "    [ParamsInitilizer]  " . $feild_name . "  value received";
                debug_rtb($log_msg, PEAR_LOG_INFO);
                $this->$feild_name = $feild_value;
                return true;
            } else {
                $log_msg = "    [ParamsInitilizerError]  " . $feild_name . "  value not set";
                debug_rtb($log_msg, PEAR_LOG_INFO);
                echo $this->error_log = $feild_name . ' is not a valid parameter';
                return $feild_name . ' is not a valid parameter';
            }
        }
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function set_value_by_array($value_array) {
		//~ print_r($value_array); die("askjk");
        $utils = new Utils;
        $defined_constants = $utils->defined_constants();
        if (is_array($value_array) AND !empty($value_array)) {
            foreach ($value_array as $key => $data) {

                if (array_key_exists($key, $defined_constants)) {
                    $log_msg = "    [ParamsInitilizer]  " . $key . "  value received";
                    debug_rtb($log_msg, PEAR_LOG_INFO);
                    $this->$key = $data;
                } else {
                    $log_msg = "    [ParamsInitilizerError]  " . $key . "  value not set";
                    debug_rtb($log_msg, PEAR_LOG_INFO);
                   echo $error_log = $key . ' is not a valid parameter';
                    return $key . ' is not a valid parameter';
                }
            }
        }
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function prepare_request_hirearchy($request_id, $impression_id, $tmp_objects) {
		
        if ($request_id AND $impression_id AND $tmp_objects) {
            $object = array('id' => $request_id); //Add request id dynamically for each request.
            $request_object = new Traffic();
            $req_objects = $request_object->request_object();

            foreach ($req_objects as $key => $data)
                if (!empty($tmp_objects[$data['name']]))
                    $object[$data['name']] = $tmp_objects[stripslashes($data['name'])];

            #impression object array
            if (isset($tmp_objects['imp_object']))
                $imp_object = (json_decode($tmp_objects['imp_object'], TRUE));
                
            #video object array
            if (isset($tmp_objects['video_object']))
                $video_object = (array) json_decode($tmp_objects['video_object']);
                
			#native object array
            if (isset($tmp_objects['native_object']))
                $native_object = (array) json_decode($tmp_objects['native_object']);
            #banner object array
            if (isset($tmp_objects['banner_object']))
                $banner_object = (array) json_decode($tmp_objects['banner_object']);
			#audio object array
            if (isset($tmp_objects['audio_object']))
                $audio_object = (array) json_decode($tmp_objects['audio_object']);                
            #site object array
            if (isset($tmp_objects['site_object']))
                $site_object = (array) json_decode($tmp_objects['site_object']);
            #app object array
            if (isset($tmp_objects['app_object']))
                $app_object = (array) json_decode($tmp_objects['app_object']); 
            #publisher object array
            if (isset($tmp_objects['publisher_object']))
                $publisher_object = (array) json_decode($tmp_objects['publisher_object']);
            #content object array
            if (isset($tmp_objects['content_object']))
                $content_object = (array) json_decode($tmp_objects['content_object']);
            #producer object array
            if (isset($tmp_objects['producer_object']))
                $producer_object = (array) json_decode($tmp_objects['producer_object']);
            #user object array
            if (isset($tmp_objects['user_object']))
                $user_object = (array) json_decode($tmp_objects['user_object']);
            #device object array
            if (isset($tmp_objects['device_object']))
                $device_object = (array) json_decode($tmp_objects['device_object']);
            #geo object array
            if (isset($tmp_objects['geo_object']))
                $geo_object = (array) json_decode($tmp_objects['geo_object']);
            #data object array
            if (isset($tmp_objects['data_object']))
                $data_object = (array) json_decode($tmp_objects['data_object']);
            #segment object array
            if (isset($tmp_objects['segment_object']))
                $segment_object = (array) json_decode($tmp_objects['segment_object']);
			#pmp object array
            if (isset($tmp_objects['pmp_object']))
                $pmp_object = (array) json_decode($tmp_objects['pmp_object']);
            #deal object array
            if (isset($tmp_objects['deal_object']))
                $deal_object = (array) json_decode($tmp_objects['deal_object']);    
            if (isset($imp_object['imp']))
                $a = (array) $imp_object['imp'];
            if (isset($banner_object))
                $b = (array) $banner_object['banner']; 
            if (isset($audio_object['audio']))
                $au = (array) $audio_object['audio']; 
            if (!empty($site_object)) {
                if (isset($site_object['site'])) {
                    $c = (array) $site_object['site'];
                    $site_or_app = 'site';
                }
            } else {
                if (isset($app_object['app'])) {
                    $c = (array) $app_object['app'];
                    $site_or_app = 'app';
                }
            }
            if (isset($publisher_object['publisher']))
                $d = (array) $publisher_object['publisher'];
            if (isset($content_object['content']))
                $e = (array) $content_object['content'];
            if (isset($producer_object['producer']))
                $f = (array) $producer_object['producer'];
            if (isset($user_object['user']))
                $g = (array) $user_object['user'];
            if (isset($device_object['device']))
                $h = (array) $device_object['device'];
            if (isset($geo_object['geo']))
                $i = (array) $geo_object['geo'];
            if (isset($data_object['data']))
                $j = (array) $data_object['data'];
            if (isset($segment_object['segment']))
                $k = (array) $segment_object['segment'];
            if (isset($pmp_object['pmp']))
                $l = (array) $pmp_object['pmp'];
            if (isset($deal_object['deal']))
                $m = (array) $deal_object['deal'];     
            
            // video
             if (isset($video_object['video']))
                $v = (array) $video_object['video'];
           // video     
            
                if (isset($native_object['native']))    //Native
                //print_r($native_object['native']); exit;     
                $native_object['native']->assets = json_decode($native_object['native']->assets,true);
                 
                $p = (array) $native_object['native'];
             
             //app object
             
             if($site_or_app=='app')
             {  
				  $object['imp'][0]['app'] = $c;
			 }
              
            if (!empty($a))
            {
                $object['imp'][0] = $a;
            }
            
          
            //video              
            if(!empty($v) && !empty($b))
            {
                $object['imp'][0]['video'] = $v;
                $object['imp'][0]['video']['companionad'] = $b;
			}
			
            elseif(!empty($v))
            {
                $object['imp'][0]['video'] = $v;
            } 
            //video  
			elseif (!empty($b))
			{
                $object['imp'][0]['banner'] = $b; 
            }  
            //audio  
			elseif (!empty($au))
			{
                $object['imp'][0]['audio'] = $au; 
            }          
			if (!empty($l))
            {
                $object['imp'][0]['pmp'] = $l;
            } 
            if (!empty($p)) //Native
            {
                $object['imp'][0]['native'] = $p;
            }   //Native
            if (!empty($m))
            {
                $object['imp'][0]['pmp']['deals'] = $m; 
            }
            if (!empty($c))
                $object[$site_or_app] = $c;
            if (!empty($d))
                $object[$site_or_app]['publisher'] = $d;
            if (!empty($e))
                $object[$site_or_app]['content'] = $e;
            if (!empty($f))
                $object[$site_or_app]['content']['producer'] = $f;

            if (!empty($g))
                $object['user'] = $g;

            if (!empty($h))
                $object['device'] = $h;
            if (!empty($i)) {
                //~ $object['user']['geo'] = $i;
                $object['device']['geo'] = $i;
            }
            if (!empty($j))
                $object['user']['data'] = $j;
            if (!empty($k))
                $object['user']['data']['segment'] = $k;

            return ($object);
        }
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function debug($error_log = false) {
        echo "<br/>=========================================================================<br/>";
        echo "<h3>RTB request - Debugger</h3>";
        echo "==============================================================================<br/>";

        if (!empty($this->error_log)) {
            echo "<h4>Response</h4>";
            echo "<code>" . 'Request error' . "</code><br/>\n\n";
            echo "<h4>Errors</h4>";
            echo "<strong>Code:</strong> 500 <br/>\n";
            echo "<br/>";
            echo "<strong>Message:</strong> <br/>";
            $i = 1;
            if (is_array($this->error_log)) {
                foreach ($this->error_log as $data) {
                    echo $i . ')' . $data;
                    echo "<br/>";
                    $i++;
                }
            } else
                echo $i . ')' . $this->error_log;

            echo "<br/>\n";
        } else
            echo "<h4>Success</h4>";

        exit;
    }

}

/* End of file request.php */
